package gov.va.med.mhv.usermgmt.service.impl;

import gov.va.med.mhv.usermgmt.bizobj.FacilityInfoAssembler;
import gov.va.med.mhv.usermgmt.bizobj.FacilityInfoBO;
import gov.va.med.mhv.usermgmt.service.FacilityInfoCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.FacilityInfoServiceResponse;
import gov.va.med.mhv.usermgmt.service.FacilityService;
import gov.va.med.mhv.usermgmt.transfer.Patient;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

/**
 * Service implementation class for the Facility service
 */
public class FacilityServiceImpl implements FacilityService {

	/**
	 * Execute the QueryFacilityInfoByStationNumber service
	 *
	 * @return FacilityInfoServiceResponse
	 */
	public FacilityInfoServiceResponse queryFacilityInfoByStationNumber(String stationNumber) {
		FacilityInfoServiceResponse response = new FacilityInfoServiceResponse();
		
		//no need to query if a blank station number is passed:
		if (StringUtils.isNotBlank(stationNumber)) {
			FacilityInfoBO bo;
			List queryResults = FacilityInfoBO.queryByStationNumber(stationNumber);
			if (queryResults.size() > 0) {
				//we can assume there is exactly one b/c of a unique constraint in the DB:
				bo = (FacilityInfoBO)queryResults.iterator().next();
				response.setFacilityInfo(bo.getFacilityInfoValues());
				
			}			
			
		}	
		
		return response;
	}
	
	/**
	 * Execute the QueryFacilityInfoByPatient service
	 *
	 * @return FacilityInfoCollectionServiceResponse
	 */
	public FacilityInfoCollectionServiceResponse queryFacilityInfoByPatient(Patient patient) {
		FacilityInfoCollectionServiceResponse response = new FacilityInfoCollectionServiceResponse();
		
		//no need to query if a blank station number is passed:
		if (patient != null) {
			FacilityInfoBO bo;
			List queryResults = FacilityInfoBO.queryByPatient(patient);
			if (queryResults.size() > 0) {
				Iterator resultIterator = queryResults.iterator();
				while (resultIterator.hasNext()) {
					bo = (FacilityInfoBO)resultIterator.next();
					response.addFacilityInfo(bo.getFacilityInfoValues());
				}
			}
			
		}
		
		return response;
	}

	/**
	 * Execute the GetAllFacilityInfos service
	 *
	 * @return FacilityInfoCollectionServiceResponse
	 */
	public FacilityInfoCollectionServiceResponse getAllFacilityInfos() {
		FacilityInfoCollectionServiceResponse response = new FacilityInfoCollectionServiceResponse();
		
		List infoBOs = FacilityInfoBO.getAllFacilityInfos();
		Collection infoTOs = FacilityInfoAssembler.getFacilityInfoCollection(infoBOs);
		response.addFacilityInfos(infoTOs);
		
		return response;
	}

}